//	VCUtil32.cpp
//
//	Generic Wrapper Functions
//
//	Function name: 'type'Function means returns a 'type'
//	Parameters:
//		HMODULE hMod - DLL module handle with function
//		const char* szFunction - function name
//		remainder of parameters - overloaded for possible combinations
//

#include "stdafx.h"

#include "VCType32.h"
#include "VCUtil32.h"

#ifdef VCLINK_STATIC
#else
#endif

BYTE WINAPI BYTEFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef BYTE (CALLBACK* GenericProc) (short*);
	BYTE vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

BYTE WINAPI BYTEFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef BYTE (CALLBACK* GenericProc) (short*, short);
	BYTE vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

double WINAPI doubleFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef double (CALLBACK* GenericProc) (short*);
	double vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

double WINAPI doubleFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2)
{
	typedef double (CALLBACK* GenericProc) (short*, char*);
	double vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

double WINAPI doubleFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef double (CALLBACK* GenericProc) (short*, short);
	double vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

float WINAPI floatFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef float (CALLBACK* GenericProc) (short*, short);
	float vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

HINSTANCE WINAPI HINSTANCEFunction(HMODULE hMod, const char* szFunction)
{
	typedef HINSTANCE (CALLBACK* GenericProc) ();
	HINSTANCE vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)();
		}
	}

	return vReturn;
}

HMENU WINAPI HMENUFunction(HMODULE hMod, const char* szFunction)
{
	typedef HMENU (CALLBACK* GenericProc) ();
	HMENU vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)();
		}
	}

	return vReturn;
}

HWND WINAPI HWNDFunction(HMODULE hMod, const char* szFunction)
{
	typedef HWND (CALLBACK* GenericProc) ();
	HWND vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)();
		}
	}

	return vReturn;
}

HWND WINAPI HWNDFunction(HMODULE hMod, const char* szFunction, short v1)
{
	typedef HWND (CALLBACK* GenericProc) (short);
	HWND vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

HWND WINAPI HWNDFunction(HMODULE hMod, const char* szFunction, WORD v1)
{
	typedef HWND (CALLBACK* GenericProc) (WORD);
	HWND vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction)
{
	typedef int (CALLBACK* GenericProc) ();
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)();
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, long v1)
{
	typedef int (CALLBACK* GenericProc) (long);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef int (CALLBACK* GenericProc) (short*);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2)
{
	typedef int (CALLBACK* GenericProc) (short*, char*);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3)
{
	typedef int (CALLBACK* GenericProc) (short*, char*, char*);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, HWND v2)
{
	typedef int (CALLBACK* GenericProc) (short*, HWND);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, long v2)
{
	typedef int (CALLBACK* GenericProc) (short*, long);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3)
{
	typedef int (CALLBACK* GenericProc) (short*, long, long);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2)
{
	typedef int (CALLBACK* GenericProc) (short*, Point2D*);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef int (CALLBACK* GenericProc) (short*, short);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

int WINAPI intFunction(HMODULE hMod, const char* szFunction, WORD v1, WORD v2, LPARAM v3)
{
	typedef int (CALLBACK* GenericProc) (WORD, WORD, LPARAM);
	int vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

Point2D WINAPI Point2DFunction(HMODULE hMod, const char* szFunction, long v1)
{
	typedef Point2D (CALLBACK* GenericProc) (long);
	Point2D vReturn;	vReturn.x = vReturn.y = 0.0;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

Point2D WINAPI Point2DFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef Point2D (CALLBACK* GenericProc) (short*);
	Point2D vReturn;	vReturn.x = vReturn.y = 0.0;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

Point2D WINAPI Point2DFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef Point2D (CALLBACK* GenericProc) (short*, short);
	Point2D vReturn;	vReturn.x = vReturn.y = 0.0;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction)
{
	typedef short (CALLBACK* GenericProc) ();
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)();
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, char* v1)
{
	typedef short (CALLBACK* GenericProc) (char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, char* v1, char* v2, char* v3)
{
	typedef short (CALLBACK* GenericProc) (char*, char*, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, char* v1, short v2)
{
	typedef short (CALLBACK* GenericProc) (char*, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, char* v1, short v2, short v3)
{
	typedef short (CALLBACK* GenericProc) (char*, short, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, long* v1, short v2)
{
	typedef short (CALLBACK* GenericProc) (long*, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short v1)
{
	typedef short (CALLBACK* GenericProc) (short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short v1, char* v2)
{
	typedef short (CALLBACK* GenericProc) (short, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short v1, short v2)
{
	typedef short (CALLBACK* GenericProc) (short, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef short (CALLBACK* GenericProc) (short*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2)
{
	typedef short (CALLBACK* GenericProc) (short*, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3)
{
	typedef short (CALLBACK* GenericProc) (short*, char*, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3, short v4)
{
	typedef short (CALLBACK* GenericProc) (short*, char*, char*, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, double* v3)
{
	typedef short (CALLBACK* GenericProc) (short*, char*, double*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, short v3)
{
	typedef short (CALLBACK* GenericProc) (short*, char*, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, short v3, short v4, double* v5)
{
	typedef short (CALLBACK* GenericProc) (short*, char*, short, short, double*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, WORD v3)
{
	typedef short (CALLBACK* GenericProc) (short*, char*, WORD);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, short v3)
{
	typedef short (CALLBACK* GenericProc) (short*, long, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, HMENU* v2)
{
	typedef short (CALLBACK* GenericProc) (short*, HMENU*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, long v2)
{
	typedef short (CALLBACK* GenericProc) (short*, long);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, short* v3)
{
	typedef short (CALLBACK* GenericProc) (short*, long, short*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, long* v2)
{
	typedef short (CALLBACK* GenericProc) (short*, long*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef short (CALLBACK* GenericProc) (short*, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, char* v3)
{
	typedef short (CALLBACK* GenericProc) (short*, short, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3)
{
	typedef short (CALLBACK* GenericProc) (short*, short, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, char* v4)
{
	typedef short (CALLBACK* GenericProc) (short*, short, short, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, char* v4, short v5)
{
	typedef short (CALLBACK* GenericProc) (short*, short, short, char*, short);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, short v4, short v5, float v6)
{
	typedef short (CALLBACK* GenericProc) (short*, short, short, short, short, float);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short* v3, short* v4, short* v5, float* v6)
{
	typedef short (CALLBACK* GenericProc) (short*, short, short*, short*, short*, float*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short* v2)
{
	typedef short (CALLBACK* GenericProc) (short*, short*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3)
{
	typedef short (CALLBACK* GenericProc) (short*, long, long);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, WORD v1)
{
	typedef short (CALLBACK* GenericProc) (WORD);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, WORD v1, short v2, char* v3)
{
	typedef short (CALLBACK* GenericProc) (WORD, short, char*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, WORD v1, vbool v2)
{
	typedef short (CALLBACK* GenericProc) (WORD, vbool);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, WORD v1, WORD v2, LPARAM v3)
{
	typedef short (CALLBACK* GenericProc) (WORD, WORD, LPARAM);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, long v1)
{
	typedef short (CALLBACK* GenericProc) (long);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

short WINAPI shortFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, EAttr* v3)
{
	typedef short (CALLBACK* GenericProc) (short*, short, EAttr*);
	short vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1,v2,v3);
		}
	}

	return vReturn;
}

UINT WINAPI UINTFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef UINT (CALLBACK* GenericProc) (short*);
	UINT vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}

UINT WINAPI UINTFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3, long v4)
{
	typedef UINT (CALLBACK* GenericProc) (short*, long, long, long);
	UINT vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return vReturn;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction)
{
	typedef void (CALLBACK* GenericProc) ();

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)();
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, char* v1)
{
	typedef void (CALLBACK* GenericProc) (char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, char* v1, char* v2)
{
	typedef void (CALLBACK* GenericProc) (char*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, char* v1, char* v2, vbool v3)
{
	typedef void (CALLBACK* GenericProc) (char*, char*, vbool);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, char* v1, short v2)
{
	typedef void (CALLBACK* GenericProc) (char*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, char* v1, short v2, vbool v3)
{
	typedef void (CALLBACK* GenericProc) (char*, short, vbool);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, char* v1, short* v2)
{
	typedef void (CALLBACK* GenericProc) (char*, short*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, EAttr* v1)
{
	typedef void (CALLBACK* GenericProc) (EAttr*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, HMENU v1)
{
	typedef void (CALLBACK* GenericProc) (HMENU);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, HWND v1)
{
	typedef void (CALLBACK* GenericProc) (HWND);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, long v1)
{
	typedef void (CALLBACK* GenericProc) (long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, long v1, char v2)
{
	typedef void (CALLBACK* GenericProc) (long, char);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, long v1, Point2D* v2)
{
	typedef void (CALLBACK* GenericProc) (long, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, long v1, RECT v2)
{
	typedef void (CALLBACK* GenericProc) (long, RECT);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, long v1, RECT* v2)
{
	typedef void (CALLBACK* GenericProc) (long, RECT*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, long v1, WORD v2)
{
	typedef void (CALLBACK* GenericProc) (long, WORD);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, lPoint2D v1, short v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (lPoint2D, short, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, lPoint2D* v1, short v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (lPoint2D*, short, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, Point2D v1)
{
	typedef void (CALLBACK* GenericProc) (Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, Point2D* v1)
{
	typedef void (CALLBACK* GenericProc) (Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, Point2D* v1, Point2D* v2)
{
	typedef void (CALLBACK* GenericProc) (Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, Point2D* v1, Point2D* v2, Point2D* v3, Point2D* v4, Point2D* v5)
{
	typedef void (CALLBACK* GenericProc) (Point2D*, Point2D*, Point2D*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short v1)
{
	typedef void (CALLBACK* GenericProc) (short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short v1, char* v2, char* v3)
{
	typedef void (CALLBACK* GenericProc) (short, char*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short v1, short v2)
{
	typedef void (CALLBACK* GenericProc) (short, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef void (CALLBACK* GenericProc) (short*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, BOOL v2)
{
	typedef void (CALLBACK* GenericProc) (short*, BOOL);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, BYTE v2)
{
	typedef void (CALLBACK* GenericProc) (short*, BYTE);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3, char* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, char*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3, char* v4, char* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, char*, char*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3, char* v4, short v5)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, char*, char*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3, long v4)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, char*, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, char* v3, long v4, long v5)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, char*, long, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, double v3)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, int v3)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, int);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, Point2D v3)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, char* v2, short v3, vbool v4)
{
	typedef void (CALLBACK* GenericProc) (short*, char*, short, vbool);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double v2)
{
	typedef void (CALLBACK* GenericProc) (short*, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double v2, double v3)
{
	typedef void (CALLBACK* GenericProc) (short*, double, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double v2, double* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, double, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double* v2, char* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, double*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double* v2, double* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, double*, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double* v2, double* v3, double* v4, double* v5, double* v6)
{
	typedef void (CALLBACK* GenericProc) (short*, double*, double*, double*, double*, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, double* v2, Point2D* v3, Point2D* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, double*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3, Point2D* v4, Point2D* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, long, long, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, Point2D* v3, Point2D* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, long, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, Point2D* v3, Point2D* v4, double v5)
{
	typedef void (CALLBACK* GenericProc) (short*, long, Point2D*, Point2D*, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, short v3, short v4)
{
	typedef void (CALLBACK* GenericProc) (short*, long, short, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3)
{
	typedef void (CALLBACK* GenericProc) (short*, long, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, long*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, float v2)
{
	typedef void (CALLBACK* GenericProc) (short*, float);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, float* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, float*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, HCURSOR v2)
{
	typedef void (CALLBACK* GenericProc) (short*, HCURSOR);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, HMENU v2)
{
	typedef void (CALLBACK* GenericProc) (short*, HMENU);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, HWND v2, vbool v3)
{
	typedef void (CALLBACK* GenericProc) (short*, HWND, vbool);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, iPoint2D v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, iPoint2D, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, iPoint2D* v2, iPoint2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, iPoint2D*, iPoint2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, iPoint2D* v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, iPoint2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2)
{
	typedef void (CALLBACK* GenericProc) (short*, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3, long v4)
{
	typedef void (CALLBACK* GenericProc) (short*, long, long, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long v3, long v4, long v5, long v6)
{
	typedef void (CALLBACK* GenericProc) (short*, long, long, long, long, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (short*, long, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, long v2, long* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, long, long*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, PlotStruct* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, PlotStruct*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D v2)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, double* v3, double* v4, double* v5, double* v6)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, double*, double*, double*, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, long v3, Point2D* v4, Point2D* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, long, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, Point2D* v3, Point2D* v4, double v5, double v6)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, Point2D*, Point2D*, double, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, Point2D* v3, Point2D* v4, Point2D* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, Point2D*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, short v3, Point2D* v4, short* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, short, Point2D*, short*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point2D* v2, short* v3, short v4, double v5)
{
	typedef void (CALLBACK* GenericProc) (short*, Point2D*, short*, short, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point3D* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, Point3D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point3D* v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, Point3D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, Point3D* v2, Point3D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, Point3D*, Point3D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, PrintStruct* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, PrintStruct*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2)
{
	typedef void (CALLBACK* GenericProc) (short*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, BYTE v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, BYTE);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, char* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, char* v3, char* v4, char* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, short, char*, char*, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, char* v3, short* v4, short* v5, double* v6)
{
	typedef void (CALLBACK* GenericProc) (short*, short, char*, short*, short*, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, double v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, double);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, double* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, double*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, float v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, float);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, long v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, long v3, long v4, long v5, long v6)
{
	typedef void (CALLBACK* GenericProc) (short*, short, long, long, long, long);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D v3, Point2D v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D v3, Point2D v4, Point2D v5)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D, Point2D, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D v3, Point2D v4, Point2D v5, Point2D v6)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D, Point2D, Point2D, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D v3, Point2D v4, Point2D v5, Point2D v6, Point2D v7, Point2D v8, Point2D v9)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D, Point2D, Point2D, Point2D, Point2D, Point2D, Point2D);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6, v7, v8, v9);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D* v3, Point2D* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D* v3, Point2D* v4, Point2D* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D* v3, Point2D* v4, Point2D* v5, Point2D* v6)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D* v3, Point2D* v4, Point2D* v5, Point2D* v6, Point2D* v7, Point2D* v8, Point2D* v9)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D*, Point2D*, Point2D*, Point2D*, Point2D*, Point2D*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6, v7, v8, v9);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point2D* v3, short v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point2D*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point3D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point3D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point3D* v3, Point3D* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point3D*, Point3D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, Point3D* v3, short v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, Point3D*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, char* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, short, char*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, char* v4, char* v5, short v6)
{
	typedef void (CALLBACK* GenericProc) (short*, short, short, char*, char*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5, v6);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, double v4, short v5)
{
	typedef void (CALLBACK* GenericProc) (short*, short, short, double, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short v3, vbool v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, short, vbool);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, short* v3, double* v4, short* v5)
{
	typedef void (CALLBACK* GenericProc) (short*, short, short*, double*, short*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4, v5);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, void* v3, short v4)
{
	typedef void (CALLBACK* GenericProc) (short*, short, void*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, short*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short* v2, Point2D* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short*, Point2D*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, ULONG v2)
{
	typedef void (CALLBACK* GenericProc) (short*, UINT);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, UINT v2, UINT v3, UINT v4)
{
	typedef void (CALLBACK* GenericProc) (short*, UINT, UINT, UINT);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, UINT v2, WORD v3)
{
	typedef void (CALLBACK* GenericProc) (short*, UINT, WORD);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, vbool* v2, vbool* v3, vbool* v4)
{
	typedef void (CALLBACK* GenericProc) (short*, vbool*, vbool*, vbool*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3, v4);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, void* v2)
{
	typedef void (CALLBACK* GenericProc) (short*, void*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, void* v2, short v3)
{
	typedef void (CALLBACK* GenericProc) (short*, void*, short);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, WORD v2)
{
	typedef void (CALLBACK* GenericProc) (short*, WORD);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, WORD v1)
{
	typedef void (CALLBACK* GenericProc) (WORD);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, WORD v1, WORD v2)
{
	typedef void (CALLBACK* GenericProc) (WORD, WORD);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2);
		}
	}

	return;
}

void WINAPI voidFunction(HMODULE hMod, const char* szFunction, short* v1, short v2, EAttr* v3)
{
	typedef void (CALLBACK* GenericProc) (short*, short, EAttr*);

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			((GenericProc)fp)(v1, v2, v3);
		}
	}

	return;
}

WORD WINAPI WORDFunction(HMODULE hMod, const char* szFunction)
{
	typedef WORD (CALLBACK* GenericProc) ();
	WORD vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)();
		}
	}

	return vReturn;
}

WORD WINAPI WORDFunction(HMODULE hMod, const char* szFunction, short* v1)
{
	typedef WORD (CALLBACK* GenericProc) (short*);
	WORD vReturn = NULL;

	if (hMod)
	{
		FARPROC fp = GetProcAddress(hMod, szFunction);
		if (fp)
		{
			vReturn = ((GenericProc)fp)(v1);
		}
	}

	return vReturn;
}
